/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.capabilities;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.Caps;
import tictim.paraglider.capabilities.PlayerState;
import tictim.paraglider.capabilities.Stamina;
import tictim.paraglider.contents.Contents;

public abstract class PlayerMovement
implements Stamina,
ICapabilityProvider {
    public static final int RECOVERY_DELAY = 10;
    public final PlayerEntity player;
    private PlayerState state = PlayerState.IDLE;
    private int stamina = ModCfg.startingStamina();
    private boolean depleted;
    private int recoveryDelay;
    private int staminaVessels;
    private int heartContainers;
    private final LazyOptional<PlayerMovement> self = LazyOptional.of(() -> this);

    public PlayerMovement(PlayerEntity player) {
        this.player = Objects.requireNonNull(player);
    }

    public PlayerState getState() {
        return this.state;
    }

    public void setState(PlayerState state) {
        this.state = Objects.requireNonNull(state);
    }

    @Override
    public int getStamina() {
        return this.stamina;
    }

    @Override
    public void setStamina(int stamina) {
        this.stamina = stamina;
    }

    @Override
    public boolean isDepleted() {
        return this.depleted;
    }

    @Override
    public void setDepleted(boolean depleted) {
        this.depleted = depleted;
    }

    @Override
    public int giveStamina(int amount, boolean simulate) {
        if (amount <= 0) {
            return 0;
        }
        int maxStamina = this.getMaxStamina();
        int staminaToGive = Math.min(amount, maxStamina - this.stamina);
        if (staminaToGive <= 0) {
            return 0;
        }
        if (!simulate) {
            this.stamina += staminaToGive;
        }
        return staminaToGive;
    }

    @Override
    public int takeStamina(int amount, boolean simulate, boolean ignoreDepletion) {
        if (amount <= 0 || this.isDepleted() && !ignoreDepletion) {
            return 0;
        }
        int staminaToTake = Math.min(amount, this.stamina);
        if (staminaToTake <= 0) {
            return 0;
        }
        if (!simulate) {
            this.stamina -= staminaToTake;
        }
        return staminaToTake;
    }

    public int getRecoveryDelay() {
        return this.recoveryDelay;
    }

    public void setRecoveryDelay(int recoveryDelay) {
        this.recoveryDelay = recoveryDelay;
    }

    public int getStaminaVessels() {
        return this.staminaVessels;
    }

    public void setStaminaVessels(int staminaVessels) {
        this.staminaVessels = Math.max(0, staminaVessels);
    }

    public int getHeartContainers() {
        return this.heartContainers;
    }

    public void setHeartContainers(int heartContainers) {
        this.heartContainers = Math.max(0, heartContainers);
    }

    @Override
    public int getMaxStamina() {
        ModifiableAttributeInstance attribute = this.player.func_110148_a((Attribute)Contents.MAX_STAMINA.get());
        if (attribute != null) {
            return (int)attribute.func_111126_e();
        }
        ParagliderMod.LOGGER.error("Player {} doesn't have max stamina attribute", (Object)this.player);
        return ModCfg.maxStamina(this.staminaVessels);
    }

    public boolean canUseParaglider() {
        return this.player.field_71075_bZ.field_75098_d || !this.depleted;
    }

    public abstract boolean isParagliding();

    public abstract void update();

    protected void updateStamina() {
        if (this.state.isConsume()) {
            this.recoveryDelay = 10;
            if (!this.depleted && (this.state.isParagliding() ? ModCfg.paraglidingConsumesStamina() : ModCfg.runningConsumesStamina())) {
                this.stamina = Math.max(0, this.stamina + this.state.change());
            }
        } else if (this.recoveryDelay > 0) {
            --this.recoveryDelay;
        } else if (this.state.change() > 0) {
            this.stamina = Math.min(this.getMaxStamina(), this.stamina + this.state.change());
        }
    }

    protected void applyMovement() {
        if (!this.player.field_71075_bZ.field_75098_d && this.isDepleted()) {
            this.player.func_195064_c(new EffectInstance((Effect)Contents.EXHAUSTED.get(), 2, 0, false, false, false));
        }
        if (this.isParagliding()) {
            this.player.field_70143_R = 0.0f;
            Vector3d m = this.player.func_213322_ci();
            switch (this.state) {
                case PARAGLIDING: {
                    if (!(m.field_72448_b < -0.05)) break;
                    this.player.func_213317_d(new Vector3d(m.field_72450_a, -0.05, m.field_72449_c));
                    break;
                }
                case ASCENDING: {
                    if (!(m.field_72448_b < 0.25)) break;
                    this.player.func_213317_d(new Vector3d(m.field_72450_a, Math.max(m.field_72448_b + 0.05, 0.25), m.field_72449_c));
                }
            }
        }
    }

    public void copyTo(PlayerMovement another) {
        another.setRecoveryDelay(this.getRecoveryDelay());
        another.setStaminaVessels(this.getStaminaVessels());
        another.setHeartContainers(this.getHeartContainers());
        another.setStamina(this.getMaxStamina());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return cap == Caps.playerMovement || cap == Caps.stamina ? this.self.cast() : LazyOptional.empty();
    }

    @Nullable
    public static PlayerMovement of(ICapabilityProvider capabilityProvider) {
        return (PlayerMovement)capabilityProvider.getCapability(Caps.playerMovement).orElse(null);
    }
}

